'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - DTC Printers                            **/
'/**                                                                       **/
'/**  MODULE NAME  : Printer.vb                                            **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/
Imports System.Net

Partial Public Class Main

#Region "=== Initialisation ==="

    Private Sub InitPrinterTab()
        InitSessionConfigCombo()
        InitErrorResponseCombo()
        InitMoveFilmCombo()
        InitHandFeedCombo()
        InitEjectModeCombo()
        InitHorzEjectCombo()
        InitEraseSpeedCombo()
        InitSmartModeCombo()
        InitIPModeCombo()

        Dim myFileVersionInfo As FileVersionInfo = FileVersionInfo.GetVersionInfo("SDKShim.dll")
        PrinterMsgBox.AppendText("Demo Version: " + Application.ProductVersion + Environment.NewLine)
        PrinterMsgBox.AppendText(myFileVersionInfo.FileDescription + " Version: " + myFileVersionInfo.FileVersion + Environment.NewLine)
        PrinterMsgBox.AppendText(SDK.ID_SDKBits().ToString + " Bit SDK" + Environment.NewLine + Environment.NewLine)
    End Sub

#End Region

    '*********************************************************************

#Region "=== Local Methods ==="

    Private Sub PrinterGetRadio_CheckedChanged(sender As System.Object, e As System.EventArgs) _
                Handles PrinterGetRadio.CheckedChanged
        PrinterTabGetSetControls(False)
    End Sub

    Private Sub PrinterSetRadio_CheckedChanged(sender As System.Object, e As System.EventArgs) _
                Handles PrinterSetRadio.CheckedChanged
        PrinterTabGetSetControls(True)
    End Sub

    Private Function PrinterActionIsGet() As Boolean
        Return PrinterGetRadio.Checked
    End Function

    Private Sub ClearPrinterMsgButton_Click(sender As System.Object, e As System.EventArgs) Handles ClearPrinterMsgButton.Click
        PrinterMsgBox.Clear()
    End Sub

    'Private Function ConnectedPrinter() As SDK.PrinterType
    '    Return SDK.ID_PrinterType(hSession)
    'End Function

    Private Sub ShowHideControls()
        Dim bControl As Boolean = (printerType = SDK.PrinterType.Generation2)

        'Controls for Rio Pro 360
        MoveFilmButton.Visible = bControl
        MoveFilmCombo.Visible = bControl
        CardLocationButton.Visible = bControl

        'Controls for Enduro
        GenCmdGroupBox.Visible = Not bControl
        GenCommandBox.Visible = Not bControl
        GenCommandButton.Visible = Not bControl
        CleanPrinterButton.Visible = Not bControl
        SmartModeButton.Visible = Not bControl
        SmartModeCombo.Visible = Not bControl
        HorzEjectButton.Visible = Not bControl
        HorzEjectCombo.Visible = Not bControl
        EraseSpeedButton.Visible = Not bControl
        EraseSpeedCombo.Visible = Not bControl
    End Sub

    Private Sub PrinterTabGetSetControls(ByVal State As Boolean)
        If hSession Then
            SmartModeCombo.Enabled = State
            EraseSpeedCombo.Enabled = State
            HorzEjectCombo.Enabled = State
            HandFeedCombo.Enabled = State
            EjectModeCombo.Enabled = State
            SmartOffsetBox.Enabled = State

            If Not ProntoPrinter() Then
                IPModeCombo.Enabled = State
                IPAddressBox.Enabled = State
                IPSubnetBox.Enabled = State
                IPGatewayBox.Enabled = State
            End If
        End If
    End Sub

    Private Sub EnableControls(ByVal State As Boolean)
        MoveFilmButton.Enabled = State
        MoveFilmCombo.Enabled = State
        CardLocationButton.Enabled = State
        GenCommandButton.Enabled = State
        GenCommandBox.Enabled = State
        CleanPrinterButton.Enabled = State
        EraseSpeedButton.Enabled = State
        HorzEjectButton.Enabled = State
        SmartModeButton.Enabled = State

        FeedMoveButton.Visible = State
        FeedMoveButton.Enabled = State
        FeedMoveCombo.Visible = State
        FeedMoveCombo.Enabled = State

        EjectCardButton.Enabled = State
        FlipCardButton.Enabled = State
        PrintTestCardButton.Enabled = State
        RestartButton.Enabled = State
        GenCommandButton.Enabled = State
        GenCommandBox.Enabled = State
        EraseCardButton.Enabled = State
        EraseArea_BotLXBox.Enabled = State
        EraseArea_BotLYBox.Enabled = State
        EraseArea_TopRXBox.Enabled = State
        EraseArea_TopRYBox.Enabled = State
        EraseCount.Enabled = State
        ErrorResponseButton.Enabled = State
        ErrorResponseCombo.Enabled = State
        PrinterGetRadio.Enabled = State
        PrinterSetRadio.Enabled = State
        HandFeedButton.Enabled = State
        EjectModeButton.Enabled = State
        HorzEjectButton.Enabled = State
        SmartModeButton.Enabled = State
        SmartOffsetButton.Enabled = State
        EraseSpeedButton.Enabled = State
        IPSettingsButton.Enabled = State

        PrinterTabGetSetControls(PrinterGetRadio.Checked = False)

        If State Then
            TabControl.Controls.Add(Information)
            TabControl.Controls.Add(Encoding)
            TabControl.Controls.Add(Driver1)
            TabControl.Controls.Add(Driver2)
            TabControl.Controls.Add(PrintDemo)
            TabControl.Controls.Add(Utils)
        Else
            TabControl.Controls.Remove(Information)
            TabControl.Controls.Remove(Encoding)
            TabControl.Controls.Remove(Driver1)
            TabControl.Controls.Remove(Driver2)
            TabControl.Controls.Remove(PrintDemo)
            TabControl.Controls.Remove(Utils)
        End If
    End Sub

    Private Function ProntoPrinter() As Boolean
        If printerType <> SDK.PrinterType.Enduro Then
            Return False
        End If

        Return SDK.ID_PrinterModel(hSession).HasFlag(SDK.Model.Pronto)
    End Function

    Private Function PrinterConnected() As Boolean
        Dim temp_string As String = ""
        Select Case SDK.ID_PrinterStatus(hSession)
            Case SDK.PrinterStatus.Ready : Return True
            Case SDK.PrinterStatus.Offline : temp_string = "Printer is offline"
            Case SDK.PrinterStatus.Error : temp_string = "Printer is in error"
            Case SDK.PrinterStatus.Busy : temp_string = "Printer is busy"
        End Select
        MessageBox.Show(temp_string, "Invalid Printer", MessageBoxButtons.OK)
        Return False
    End Function

#End Region

    '*********************************************************************

#Region "=== Open Session ==="
    Dim openconfigkp As New Dictionary(Of SDK.Config, String) From
    {
        {SDK.Config.Normal, "Config Normal"},
        {SDK.Config.Quiet, "Config Quiet"}
    }

    Private Sub InitSessionConfigCombo()
        SessionConfigCombo.DataSource = New BindingSource(openconfigkp, Nothing)
        SessionConfigCombo.DisplayMember = "Value"
        SessionConfigCombo.ValueMember = "Key"
    End Sub

    Private Sub OpenSessionButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles OpenSessionButton.Click
        pd.PrinterSettings = ps
        pd.AllowPrintToFile = True
        If pd.ShowDialog() = DialogResult.OK Then

            ps = pd.PrinterSettings

            g = ps.CreateMeasurementGraphics()
            hDC = g.GetHdc()

            Dim SDKReturn As SDK.Return = SDK.ID_OpenSession(hDC, hSession, SessionConfigCombo.SelectedItem.Key)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("OpenSession", SDKReturn)
            Else
                ResinAreaWidthUpDown.Maximum =
                AreaHoleWidthUpDown.Maximum =
                EraseAreaWidthUpDown.Maximum = SDK.ID_CardWidth(hSession)
                EraseArea_TopRXBox.Maximum =
                EraseArea_TopRXBox.Value = SDK.ID_CardWidth(hSession) - 1

                printerType = SDK.ID_PrinterType(hSession)
                If printerType <> SDK.PrinterType.Enduro _
                And printerType <> SDK.PrinterType.Generation2 Then
                    MessageBox.Show("Use with DTC Printers Only", "Invalid Printer", MessageBoxButtons.OK)
                    SDK.ID_CloseSession(hSession)

                Else
                    PrinterID.Text = "Printer: " + pd.PrinterSettings.PrinterName
                    PrinterID.Visible = True
                    PrinterPrefs.Visible = True

                    Cursor.Current = Cursors.WaitCursor
                    ShowHideControls()

                    If printerType = SDK.PrinterType.Generation2 Then
                        FeedMoveButton.Text = "MoveCard"
                        InitMoveCardCombo()
                        FeedMoveCombo.Enabled = True

                        If Not pd.PrintToFile Then
                            'Get Hand Feed status
                            Dim mode As SDK.HandFeed = New SDK.HandFeed()
                            GetHandFeed(mode)
                            SetHandFeedCombo(mode)
                        End If
                    Else
                        FeedMoveButton.Text = "FeedCard"
                        InitFeedCardCombo()
                        FeedMoveCombo.Enabled = True

                        If Not pd.PrintToFile Then
                            Dim PrinterInfo As New SDK.PrinterInfo
                            SDKReturn = SDK.ID_PrinterInfo(hSession, PrinterInfo)
                            If SDKReturn <> SDK.Return.Success Then
                                HandleError("Open - GetPrinterInfo", SDKReturn)
                            Else
                                If PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EncodePlaten) Then
                                    SetSmartModeCombo(SDK.SmartMode.Platen)
                                ElseIf PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EncodeXLI) Then
                                    SetSmartModeCombo(SDK.SmartMode.XLI)
                                Else
                                    SetSmartModeCombo(SDK.SmartMode.Default)
                                End If

                                If PrinterInfo.iHandFeed <> 0 Then
                                    SetHandFeedCombo(SDK.HandFeed.On)
                                Else
                                    SetHandFeedCombo(SDK.HandFeed.Off)
                                End If

                                If PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EraseSpeed) Then
                                    SetEraseSpeedCombo(SDK.EraseSpeed.Quick)
                                Else
                                    SetEraseSpeedCombo(SDK.EraseSpeed.Thorough)
                                End If

                                If PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EjectMode) Then
                                    SetEjectModeCombo(SDK.EjectMode.On)
                                Else
                                    SetEjectModeCombo(SDK.EjectMode.Off)
                                End If

                                If PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.HorzEject) Then
                                    SetHorzEjectCombo(SDK.HorzEject.On)
                                Else
                                    SetHorzEjectCombo(SDK.HorzEject.Off)
                                End If

                                SetSmartOffset(PrinterInfo.iSmartOffset)

                                Dim ipData As New SDK.IPData
                                GetIPSettings(ipData)

                                IPModeCombo.Enabled = True
                                IPAddressBox.Enabled = True
                                IPSubnetBox.Enabled = True
                                IPGatewayBox.Enabled = True
                            End If
                        End If
                    End If

                    If ProntoPrinter() Then
                        IPSettingsButton.Visible = False
                        IPModeCombo.Visible = False
                        IPAddressBox.Visible = False
                        IPSubnetBox.Visible = False
                        IPGatewayBox.Visible = False
                        IPGroupBox.Visible = False
                        IPModeLabel.Visible = False
                        IPAddressLabel.Visible = False
                        IPSubnetLabel.Visible = False
                        IPGatewayLabel.Visible = False
                    End If

                    If PrinterIs600DPICapable() Then
                        Dim resolution As Byte = 0
                        GetResolution(resolution)
                        ResolutionButton.Enabled = True
                    End If

                    OpenSessionButton.Visible = False
                    SessionConfigCombo.Visible = False
                    CloseSessionButton.Visible = True

                    EnableControls(True)
                    Cursor.Current = Cursors.Default
                End If
            End If

            Application.DoEvents()
        End If
    End Sub

#End Region

    '*********************************************************************

#Region "=== Close Session ==="

    Private Sub CloseSessionButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles CloseSessionButton.Click

        OpenSessionButton.Visible = True
        SessionConfigCombo.Visible = True
        CloseSessionButton.Visible = False

        PrinterID.Visible = False
        PrinterPrefs.Visible = False

        EnableControls(False)
        PrinterTabGetSetControls(False)

        printerType = SDK.PrinterType.None

        Dim SDKReturn As SDK.Return = SDK.ID_CloseSession(hSession)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("CloseSession", SDKReturn)
        End If
    End Sub

#End Region

    '*********************************************************************

#Region "=== Error Response ==="

    Dim errorresponsekp As New Dictionary(Of SDK.Response, String) From
    {
        {SDK.Response.OK, "OK"},
        {SDK.Response.Cancel, "Cancel"}
    }

    Private Sub InitErrorResponseCombo()
        ErrorResponseCombo.DataSource = New BindingSource(errorresponsekp, Nothing)
        ErrorResponseCombo.DisplayMember = "Value"
        ErrorResponseCombo.SelectedItem = SDK.Response.OK
    End Sub

    Private Sub ErrorResponseButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ErrorResponseButton.Click
        Dim response As SDK.Response = ErrorResponseCombo.SelectedItem.Key()
        Dim SDKReturn As SDK.Return = SDK.ID_ErrorResponse(hSession, response)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("ErrorResponse", SDKReturn)
        End If
    End Sub

#End Region

    '*********************************************************************

#Region "=== General Command ==="

    Private Sub GenCommandButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles GenCommandButton.Click
        If GenCommandBox.Text.Length = 0 Then
            MessageBox.Show("General Command Box is empty")
        Else
            Dim SDKReturn As SDK.Return = SDK.ID_GeneralCommand(hSession, GenCommandBox.Text)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("GeneralCommand", SDKReturn)
            Else
                WaitForPrinterToFinish()
            End If
        End If
    End Sub

#End Region

    '*********************************************************************

#Region "=== Feed/Move Card ==="

    Private Sub FeedMoveButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles FeedMoveButton.Click
        If printerType = SDK.PrinterType.Generation2 Then
            MoveCard()
        Else
            FeedCard()
        End If
    End Sub

    '--------------------------------------------------------------------------

    Dim feedcardkp As New Dictionary(Of SDK.FeedMode, String) From
    {
        {SDK.FeedMode.ChipCard, "Contact"},
        {SDK.FeedMode.Contactless, "ContactLess"}
    }

    Private Sub InitFeedCardCombo()
        FeedMoveCombo.DataSource = New BindingSource(feedcardkp, Nothing)
        FeedMoveCombo.DisplayMember = "Value"
        FeedMoveCombo.ValueMember = "Key"
        FeedMoveCombo.SelectedIndex = 0
    End Sub

    Private Sub FeedCard()
        Dim mode As SDK.FeedMode = FeedMoveCombo.SelectedItem.Key
        Dim SDKReturn As SDK.Return = SDK.ID_FeedCard(hSession, mode, 0)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("FeedCard", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If
    End Sub

    '--------------------------------------------------------------------------

    Dim movecardkp As New Dictionary(Of SDK.CardPosition, String) From
    {
        {SDK.CardPosition.Standby, "Standby"},
        {SDK.CardPosition.ContactEncoder, "Contact Encoder"},
        {SDK.CardPosition.ContactlessEncoder, "Contactless Encoder"},
        {SDK.CardPosition.Rotate, "Rotate"},
        {SDK.CardPosition.Eject, "Eject"},
        {SDK.CardPosition.Initialise, "Initialise"},
        {SDK.CardPosition.Reject, "Reject"}
    }

    Private Sub InitMoveCardCombo()
        FeedMoveCombo.DataSource = New BindingSource(movecardkp, Nothing)
        FeedMoveCombo.DisplayMember = "Value"
        FeedMoveCombo.ValueMember = "Key"
        FeedMoveCombo.SelectedIndex = 0
    End Sub

    Private Sub MoveCard()
        Cursor.Current = Cursors.WaitCursor

        Dim position As SDK.CardPosition = FeedMoveCombo.SelectedItem.Key
        Dim SDKReturn As SDK.Return = SDK.ID_MoveCard(hSession, position)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("MoveCard", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Move Film ==="

    Dim movefilmkp As New Dictionary(Of SDK.DyePanel, String) From
    {
        {SDK.DyePanel.Initialise, "Initialise"},
        {SDK.DyePanel.NextPanel, "Next"},
        {SDK.DyePanel.Yellow, "Yellow"},
        {SDK.DyePanel.Magenta, "Magenta"},
        {SDK.DyePanel.Cyan, "Cyan"},
        {SDK.DyePanel.KResin, "KResin"},
        {SDK.DyePanel.Overcoat, "Overcoat"}
    }

    Private Sub InitMoveFilmCombo()
        MoveFilmCombo.DataSource = New BindingSource(movefilmkp, Nothing)
        MoveFilmCombo.DisplayMember = "Value"
        MoveFilmCombo.ValueMember = "Key"
        MoveFilmCombo.SelectedIndex = 0
    End Sub

    Private Sub MoveFilmButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles MoveFilmButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim panel As SDK.DyePanel = MoveFilmCombo.SelectedItem.Key
        Dim SDKReturn As SDK.Return = SDK.ID_MoveFilm(hSession, panel)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("MoveFilm", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Eject Card ==="

    Private Sub EjectCardButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles EjectCardButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim SDKReturn As SDK.Return = SDK.ID_EjectCard(hSession)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("EjectCard", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Flip Card ==="

    Private Sub FlipCardButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles FlipCardButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim SDKReturn As SDK.Return = SDK.ID_FlipCard(hSession)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("FlipCard", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Clean Printer ==="

    Private Sub CleanPrinterButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles CleanPrinterButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim SDKReturn As SDK.Return = SDK.ID_CleanPrinter(hSession)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("CleanPrinter", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Restart Printer ==="

    Private Sub RestartButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles RestartButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim SDKReturn As SDK.Return = SDK.ID_RestartPrinter(hSession)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("RestartPrinter", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Print Test Card ==="

    Private Sub PrintTestButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrintTestCardButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim SDKReturn As SDK.Return

        If printerType = SDK.PrinterType.Generation2 Then
            'Call SDK to Prepare to Print a Test Card
            SDKReturn = SDK.ID_PrepareForPrint(hSession)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("PrintTestCardPrepare", SDKReturn)
            End If
        Else
            SDKReturn = SDK.ID_PrintTestCard(hSession)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("PrintTestCard", SDKReturn)
            Else
                If printerType = SDK.PrinterType.Generation2 Then
                    SDKReturn = SDK.ID_WaitPrintComplete(hSession)
                    If SDKReturn <> SDK.Return.Success Then
                        HandleError("PrintTestCardComplete", SDKReturn)
                    End If
                Else
                    WaitForPrinterToFinish()
                End If
            End If
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Erase Card ==="

    Private Sub EraseAreaButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles EraseCardButton.Click
        Dim SDKReturn As SDK.Return = SDK.ID_EraseCard(hSession, _
                                                      EraseCount.Value, _
                                                      EraseArea_BotLXBox.Value, _
                                                      EraseArea_BotLYBox.Value, _
                                                      EraseArea_TopRXBox.Value, _
                                                      EraseArea_TopRYBox.Value)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("Erasecard", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If
    End Sub

#End Region

    '*********************************************************************

#Region "=== Hand Feed ==="

    Dim handfeedkp As New Dictionary(Of SDK.HandFeed, String) From
    {
        {SDK.HandFeed.On, "On"},
        {SDK.HandFeed.Off, "Off"}
    }

    Private Sub InitHandFeedCombo()
        HandFeedCombo.DataSource = New BindingSource(handfeedkp, Nothing)
        HandFeedCombo.DisplayMember = "Value"
        HandFeedCombo.ValueMember = "Key"
    End Sub

    Private Sub HandFeedToMsgBox(ByVal Action As SDK.Action, ByVal mode As SDK.HandFeed)
        Dim sep As String = Separator(Action)
        PrinterMsgBox.AppendText("Hand Feed" + sep + handfeedkp.Item(mode) + Environment.NewLine)
        PrinterMsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetHandFeedCombo(ByVal mode As SDK.HandFeed)
        HandFeedCombo.Text = handfeedkp.Item(mode)
    End Sub

    Private Function GetHandFeed(ByRef mode As SDK.HandFeed) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_HandFeed(hSession, SDK.Action.Read, mode)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetHandFeed", SDKReturn)
        End If
        Return SDKReturn
    End Function

    Private Sub HandFeedButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles HandFeedButton.Click
        Dim mode As SDK.HandFeed = HandFeedCombo.SelectedItem.Key()

        Cursor.Current = Cursors.WaitCursor

        If PrinterActionIsGet() Then
            If GetHandFeed(mode) = SDK.Return.Success Then
                SetHandFeedCombo(mode)
                HandFeedToMsgBox(SDK.Action.Read, mode)
            End If
        Else
            Dim SDKReturn As SDK.Return = SDK.ID_HandFeed(hSession, SDK.Action.Write, mode)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetHandFeed", SDKReturn)
            Else
                HandFeedToMsgBox(SDK.Action.Write, mode)
            End If
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Eject Mode ==="

    Dim ejectmodekp As New Dictionary(Of SDK.EjectMode, String) From
    {
        {SDK.EjectMode.On, "On"},
        {SDK.EjectMode.Off, "Off"}
    }

    Private Sub InitEjectModeCombo()
        EjectModeCombo.DataSource = New BindingSource(ejectmodekp, Nothing)
        EjectModeCombo.DisplayMember = "Value"
        EjectModeCombo.ValueMember = "Key"
    End Sub

    Private Sub EjectModeToMsgBox(ByVal Action As SDK.Action, ByVal mode As SDK.EjectMode)
        Dim sep As String = Separator(Action)
        PrinterMsgBox.AppendText("Eject Mode" + sep + ejectmodekp.Item(mode) + Environment.NewLine)
        PrinterMsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetEjectModeCombo(ByVal mode As SDK.EjectMode)
        EjectModeCombo.Text = ejectmodekp.Item(mode)
    End Sub

    Private Function GetEjectMode(ByRef mode As SDK.EjectMode) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_EjectMode(hSession, SDK.Action.Read, mode)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetEjectMode", SDKReturn)
        End If
        Return SDKReturn
    End Function

    Private Sub EjectModeButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles EjectModeButton.Click
        Dim mode As SDK.EjectMode = EjectModeCombo.SelectedItem.Key()

        If PrinterActionIsGet() Then
            If GetEjectMode(mode) = SDK.Return.Success Then
                SetEjectModeCombo(mode)
                EjectModeToMsgBox(SDK.Action.Read, mode)
            End If
        Else
            Dim SDKReturn As SDK.Return = SDK.ID_EjectMode(hSession, SDK.Action.Write, mode)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetEjectMode", SDKReturn)
            Else
                EjectModeToMsgBox(SDK.Action.Write, mode)
            End If
        End If
    End Sub

#End Region

    '*********************************************************************

#Region "=== Horizontal Eject Mode ==="

    Dim horzejectkp As New Dictionary(Of SDK.HorzEject, String) From
    {
        {SDK.HorzEject.On, "On"},
        {SDK.HorzEject.Off, "Off"}
    }

    Private Sub InitHorzEjectCombo()
        HorzEjectCombo.DataSource = New BindingSource(horzejectkp, Nothing)
        HorzEjectCombo.DisplayMember = "Value"
        HorzEjectCombo.ValueMember = "Key"
    End Sub

    Private Sub HorzEjectToMsgBox(ByVal Action As SDK.Action, ByVal mode As SDK.HorzEject)
        Dim sep As String = Separator(Action)
        PrinterMsgBox.AppendText("Horz Eject" + sep + horzejectkp.Item(mode) + Environment.NewLine)
        PrinterMsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetHorzEjectCombo(ByVal mode As SDK.HorzEject)
        HorzEjectCombo.Text = horzejectkp.Item(mode)
    End Sub

    Private Function GetHorzEject(ByRef mode As SDK.HorzEject) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_HorzEject(hSession, SDK.Action.Read, mode)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("HorzEject", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub HorzEjectButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles HorzEjectButton.Click
        Dim mode As SDK.HorzEject = HorzEjectCombo.SelectedItem.Key()

        Cursor.Current = Cursors.WaitCursor

        If PrinterActionIsGet() Then
            If GetHorzEject(mode) = SDK.Return.Success Then
                SetHorzEjectCombo(mode)
                HorzEjectToMsgBox(SDK.Action.Read, mode)
            Else
                Dim SDKReturn As SDK.Return = SDK.ID_HorzEject(hSession, SDK.Action.Write, mode)
                If SDKReturn <> SDK.Return.Success Then
                    HandleError("SetHorzEject", SDKReturn)
                Else
                    HorzEjectToMsgBox(SDK.Action.Write, mode)
                End If
            End If
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Smart Mode ==="

    Dim smartmodekp As New Dictionary(Of SDK.SmartMode, String) From
    {
        {SDK.SmartMode.Default, "Default"},
        {SDK.SmartMode.Platen, "Platen"},
        {SDK.SmartMode.XLI, "XLI"}
    }

    Private Sub InitSmartModeCombo()
        SmartModeCombo.DataSource = New BindingSource(smartmodekp, Nothing)
        SmartModeCombo.DisplayMember = "Value"
        SmartModeCombo.ValueMember = "Key"
    End Sub

    Private Sub SmartModeToMsgBox(ByVal Action As SDK.Action, ByVal mode As SDK.SmartMode)
        Dim sep As String = Separator(Action)
        PrinterMsgBox.AppendText("Smart Mode" + sep + smartmodekp.Item(mode) + Environment.NewLine)
        PrinterMsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetSmartModeCombo(ByVal mode As SDK.SmartMode)
        SmartModeCombo.Text = smartmodekp.Item(mode)
    End Sub

    Private Function GetSmartMode(ByRef mode As SDK.SmartMode) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_SmartMode(hSession, SDK.Action.Read, mode)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetSmartMode", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub SmartModeButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles SmartModeButton.Click
        Dim mode As SDK.SmartMode = SmartModeCombo.SelectedItem.Key()

        Cursor.Current = Cursors.WaitCursor

        If PrinterActionIsGet() Then
            If GetSmartMode(mode) = SDK.Return.Success Then
                SetSmartModeCombo(mode)
                SmartModeToMsgBox(SDK.Action.Read, mode)
            End If
        Else
            Dim SDKReturn As SDK.Return = SDK.ID_SmartMode(hSession, SDK.Action.Write, mode)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetSmartMode", SDKReturn)
            Else
                SmartModeToMsgBox(SDK.Action.Write, mode)
            End If
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Smart Offset ==="

    Private Sub SmartOffsetToMsgBox(ByVal Action As SDK.Action, ByVal offset As Byte)
        Dim sep As String = Separator(Action)
        PrinterMsgBox.AppendText("Smart Offset" + sep + offset.ToString() + Environment.NewLine)
        PrinterMsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetSmartOffset(ByVal Offset As Byte)
        SmartOffsetBox.Value = Offset
    End Sub

    Private Function GetSmartOffset(ByRef Offset As Byte) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_SmartOffset(hSession, SDK.Action.Read, Offset)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetSmartOffset", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub SmartOffsetButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles SmartOffsetButton.Click
        Dim Offset As Byte = SmartOffsetBox.Value

        Cursor.Current = Cursors.WaitCursor

        If PrinterActionIsGet() Then
            If GetSmartOffset(Offset) = SDK.Return.Success Then
                SetSmartOffset(Offset)
                SmartOffsetToMsgBox(SDK.Action.Read, Offset)
            End If
        Else
            Dim SDKReturn As SDK.Return = SDK.ID_SmartOffset(hSession, SDK.Action.Write, Offset)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetSmartOffset", SDKReturn)
            Else
                SmartOffsetToMsgBox(SDK.Action.Write, Offset)
            End If
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Erase Speed ==="

    Dim erasespeedkp As New Dictionary(Of SDK.EraseSpeed, String) From
    {
        {SDK.EraseSpeed.Thorough, "Thorough"},
        {SDK.EraseSpeed.Quick, "Quick"}
    }

    Private Sub InitEraseSpeedCombo()
        EraseSpeedCombo.DataSource = New BindingSource(erasespeedkp, Nothing)
        EraseSpeedCombo.DisplayMember = "Value"
        EraseSpeedCombo.ValueMember = "Key"
    End Sub

    Private Sub EraseSpeedToMsgBox(ByVal Action As SDK.Action, ByVal speed As SDK.EraseSpeed)
        Dim sep As String = Separator(Action)
        PrinterMsgBox.AppendText("Erase Speed" + sep + erasespeedkp.Item(speed) + Environment.NewLine)
        PrinterMsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetEraseSpeedCombo(ByVal speed As SDK.EraseSpeed)
        EraseSpeedCombo.Text = erasespeedkp.Item(speed)
    End Sub

    Private Function GetEraseSpeed(ByRef speed As SDK.EraseSpeed) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_EraseSpeed(hSession, SDK.Action.Read, speed)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetEraseSpeed", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub EraseSpeedButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles EraseSpeedButton.Click
        Dim speed As SDK.EraseSpeed = EraseSpeedCombo.SelectedItem.Key()

        Cursor.Current = Cursors.WaitCursor

        If PrinterActionIsGet() Then
            If GetEraseSpeed(speed) = SDK.Return.Success Then
                SetEraseSpeedCombo(speed)
                EraseSpeedToMsgBox(SDK.Action.Read, speed)
            End If
        Else
            Dim SDKReturn As SDK.Return = SDK.ID_EraseSpeed(hSession, SDK.Action.Write, speed)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetEraseSpeed", SDKReturn)
            Else
                EraseSpeedToMsgBox(SDK.Action.Write, speed)
            End If
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== IP Settings ==="

    Dim ipaddresskp As New Dictionary(Of SDK.IPMode, String) From
    {
        {SDK.IPMode.Dynamic, "Dynamic"},
        {SDK.IPMode.Static, "Static"}
    }

    Private Sub InitIPModeCombo()
        IPModeCombo.DataSource = New BindingSource(ipaddresskp, Nothing)
        IPModeCombo.DisplayMember = "Value"
        IPModeCombo.ValueMember = "Key"
    End Sub

    Private Function IntToIPAddressString(ByVal value As Integer) As String
        Dim temp As VariantType = IPAddress.HostToNetworkOrder(value)
        Return New IPAddress(BitConverter.GetBytes(temp)).ToString()
    End Function

    Private Function IPAddressStringToInt(ByVal IPAddr As String) As Integer
        Return IPAddress.NetworkToHostOrder(BitConverter.ToInt32(IPAddress.Parse(IPAddr).GetAddressBytes(), 0))
    End Function

    Private Sub IPDataToMsgBox(ByVal Action As SDK.Action, ByVal settings As SDK.IPData)
        Dim sep As String = Separator(Action)
        PrinterMsgBox.AppendText("Address Mode" + sep + ipaddresskp.Item(settings.Mode) + Environment.NewLine)
        PrinterMsgBox.AppendText("IP Address" + sep + IntToIPAddressString(settings.Address) + Environment.NewLine)
        PrinterMsgBox.AppendText("Subnet Mask" + sep + IntToIPAddressString(settings.Subnet) + Environment.NewLine)
        PrinterMsgBox.AppendText("Gateway" + sep + IntToIPAddressString(settings.Gateway) + Environment.NewLine)
        PrinterMsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Function GetIPSettings(ByRef settings As SDK.IPData) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_IPSettings(hSession, SDK.Action.Read, settings)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetIPSettings", SDKReturn)
        Else
            IPModeCombo.Text = ipaddresskp.Item(settings.Mode)
            IPAddressBox.Text = IntToIPAddressString(settings.Address)
            IPSubnetBox.Text = IntToIPAddressString(settings.Subnet)
            IPGatewayBox.Text = IntToIPAddressString(settings.Gateway)
        End If

        Return SDKReturn
    End Function

    Private Sub IPSettingsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles IPSettingsButton.Click
        Dim ipdata As New SDK.IPData

        Cursor.Current = Cursors.WaitCursor

        If PrinterActionIsGet() Then
            If GetIPSettings(ipdata) = SDK.Return.Success Then
                IPDataToMsgBox(SDK.Action.Read, ipdata)
            End If
        Else
            ipdata.Mode = IPModeCombo.SelectedItem.Key
            ipdata.Address = IPAddressStringToInt(IPAddressBox.Text)
            ipdata.Subnet = IPAddressStringToInt(IPSubnetBox.Text)
            ipdata.Gateway = IPAddressStringToInt(IPGatewayBox.Text)

            Dim SDKReturn As SDK.Return = SDK.ID_IPSettings(hSession, SDK.Action.Write, ipdata)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetEraseSpeed", SDKReturn)
            Else
                IPDataToMsgBox(SDK.Action.Write, ipdata)
            End If
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '*********************************************************************

#Region "=== Card Location ==="

    Private Sub CardLocationButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CardLocationButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim location As SDK.CardLocation = New SDK.CardLocation()
        Dim SDKReturn As SDK.Return = SDK.ID_CardLocation(hSession, location)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("CardLocation", SDKReturn)
        Else
            Dim temp_string As String
            Select Case location
                Case SDK.CardLocation.Unknown
                    temp_string = "Unknown"
                Case SDK.CardLocation.NoCard
                    temp_string = "No Card"
                Case SDK.CardLocation.PrintReady
                    temp_string = "Standby"
                Case SDK.CardLocation.Encoder
                    temp_string = "Encoder"
                Case Else
                    temp_string = "?????"
            End Select
            PrinterMsgBox.AppendText("Card Location: " + temp_string + Environment.NewLine)
            PrinterMsgBox.AppendText(Environment.NewLine)
        End If

        Cursor.Current = Cursors.Default

    End Sub

#End Region

End Class
